@echo off
:: Command to create standalone copy of xperf
:: mkdir "Windows Performance Toolkit" && copy "C:\Program Files (x86)\Windows Kits\10\Windows Performance Toolkit" ".\Windows Performance Toolkit\"

echo This script must run as administrator

echo Running "%~dp0Windows Performance Toolkit\xperf" to start a trace session...
"%~dp0Windows Performance Toolkit\xperf" -on Proc_Thread+Loader+Profile+CSwitch+FILE_IO+FILE_IO_INIT -stackwalk Profile+CSwitch+FileCreate -buffersize 1024 -MaxFile 1024 -FileMode Circular 
if NOT %errorLevel% == 0 (
    echo Failed to run xperf command, please check if the path listed above is correct. 
    pause
    exit /B 1
)

echo Hint: keep tracing time under 1 minute to reduce tracing file size
echo Tracing started, reproduce a problem and press any key to stop...
pause >nul

echo Stopping a trace session, please wait it could take several minutes to finish...
"%~dp0Windows Performance Toolkit\xperf" -d "%~dp0trace.etl"
if NOT %errorLevel% == 0 (
    echo Failed to stop tracing session, please copy console output and contact Cyberhaven Support. 
    pause
    exit /B 1
)
echo Done, please compress trace.etl using "Right click->Send To->Compressed folder" or 7-zip.
pause
